<?php

namespace App\Http\Controllers\Admin;

use App\Categories;
use App\Http\Controllers\Controller;
use App\Posts;
use App\Sources;
use App\SubCategories;
use Illuminate\Support\Str;
use Input;
use Session;

class SubCategoryController extends Controller
{

    public function create()
    {

        $parent_categories = Categories::all();

        return view('admin.sub_categories.create', ['parent_categories' => $parent_categories]);
    }

    public function store()
    {

        if (!Input::has('title')) {
            Session::flash('error_msg', 'Sub Category title is required');
            return redirect()->back()->withInput(Input::all());
        }

        if (!Input::has('parent_category')) {
            Session::flash('error_msg', 'Category is required');
            return redirect()->back()->withInput(Input::all());
        }


        $category = new SubCategories();
        $category->priority = Input::get('priority', 1);
        $category->parent_id = Input::get('parent_category');
        $category->title = Input::get('title');
        $category->slug = Str::slug(Input::get('title'));
        $category->scroll_type = Input::get('scroll_type', SubCategories::SCROLL_TYPE_PAGINATION);
        $category->show_in_menu = Input::has('show_in_menu') ? 1 : 0;
        $category->show_in_sidebar = Input::has('show_in_sidebar') ? 1 : 0;
        $category->show_in_footer = Input::has('show_in_footer') ? 1 : 0;
        $category->seo_keywords = Input::get('seo_keywords', Input::get('title'));
        $category->seo_description = Input::get('seo_description', Input::get('title'));
        $category->save();

        Session::flash('success_msg', 'Sub Category created successfully');
        return redirect()->to('/admin/sub_categories/all');

    }

    public function edit($id)
    {

        if (!is_null($id) && sizeof(SubCategories::where('id', $id)->get()) > 0) {

            $category = SubCategories::where('id', $id)->first();
            return view('admin.sub_categories.edit', ['category' => $category]);

        } else {
            Session::flash('error_msg', 'Sub Category not found');
            return redirect()->to('/admin/sub_categories/all');
        }

    }

    public function delete($id)
    {
        if (!is_null($id) && sizeof(SubCategories::where('id', $id)->get()) > 0) {

            SubCategories::where('id', $id)->delete();

            Sources::where('category_id', $id)->delete();
            Posts::where('category_id', $id)->delete();

            Session::flash('success_msg', 'Sub Category deleted successfully');
            return redirect()->to('/admin/sub_categories/all');

        } else {
            Session::flash('error_msg', 'Sub Category not found');
            return redirect()->to('/admin/sub_categories/all');
        }
    }

    public function update()
    {

        if (Input::has('id') && sizeof(SubCategories::where('id', Input::get('id'))->get()) > 0) {

            if (sizeof(SubCategories::where('title', Input::get('title'))->where('id', '!=', Input::get('id'))->get()) > 0) {
                Session::flash('error_msg', 'Sub Category with given title already exists');
                return redirect()->back()->withInput(Input::all());
            }

            $category = SubCategories::where('id', Input::get('id'))->first();

            $category->title = Input::get('title');
            $category->slug = Str::slug(Input::get('title'));
            $category->scroll_type = Input::get('scroll_type', SubCategories::SCROLL_TYPE_PAGINATION);
            $category->show_in_menu = Input::has('show_in_menu') ? 1 : 0;
            $category->show_in_sidebar = Input::has('show_in_sidebar') ? 1 : 0;
            $category->show_in_footer = Input::has('show_in_footer') ? 1 : 0;
            $category->seo_keywords = Input::get('seo_keywords', Input::get('title'));
            $category->seo_description = Input::get('seo_description', Input::get('title'));
            $category->save();

            Session::flash('success_msg', 'Sub Category updated successfully');
            return redirect()->to('/admin/sub_categories/all');

        } else {
            Session::flash('error_msg', 'Sub Category not found');
            return redirect()->to('/admin/sub_categories/all');
        }

    }

    public function all()
    {

        $categories = SubCategories::all();

        foreach ($categories as $category) {
            $category->no_sources = Sources::where('category_id', $category->id)->count();
            $category->no_posts = Posts::where('category_id', $category->id)->count();
            $category->parent_category = Categories::where('id', $category->parent_id)->first();
        }

        return view('admin.sub_categories.all', ['categories' => $categories]);
    }

}